<?php

namespace App\Http\Controllers;

use App\Models\CekVersionApp;
use Illuminate\Http\Request;

class CekVersionAppController extends Controller
{
    // Menghapus middleware auth, karena kita tidak menggunakan token
    public function __construct()
    {
        // Middleware telah dihapus agar tidak ada autentikasi yang dibutuhkan
    }

    // Mendapatkan semua data versi aplikasi
    public function index(Request $request)
    {
        $cekVersionApp = CekVersionApp::all();

        return response()->json($cekVersionApp);
    }
    
    // Mendapatkan data versi aplikasi berdasarkan keydata
    public function show($id)
    {
        // Mengambil data versi aplikasi berdasarkan keydata
        $cekVersionApp = CekVersionApp::where('keydata', $id)->first(); // Menggunakan first() untuk mendapatkan satu record

        if (!$cekVersionApp) {
            return response()->json(['message' => 'Data not found'], 404);
        }

        return response()->json($cekVersionApp);
    }
}
