<?php

namespace App\Http\Controllers;

use App\Models\Dosen;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Validator;
use Illuminate\Support\Facades\DB;

class DosenController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth', ['only' => ['store', 'update', 'destroy', 'index', 'show']]);
    }

    public function index(Request $request)
    {
        $dosen = Dosen::all();

        return response()->json($dosen);
    }
    
    public function show($id)
    {
        // Menggunakan eager loading untuk memuat relasi yang diperlukan
        $dosen = Dosen::find($id);
    
        if (!$dosen) {
            return response()->json(['message' => 'Data not found'], 404);
        }
        
        return response()->json($dosen);
    }
    

}
