<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use App\Models\EvaluasiAkademik;
use DB; 

class EvaluasiAkademikController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth', ['only' => ['store', 'update', 'destroy', 'index', 'show']]);
    }
    
    public function ListDosen($nim)
    {
        $query1 = DB::table('t_kuesioner_evaluasi as a')
            ->join('m_kuesioner_evaluasi as b', 'a.id_kuesioner', '=', 'b.id_kategori')
            ->join('m_tahun_ajar as d', 'a.kd_tahun', '=', 'd.kd_tahun_ajar')
            ->join('m_semester as e', 'a.kd_semester', '=', 'e.kd_semester')
            ->join('kelas_perkuliahan as g', function($join) {
                $join->on('a.nidn', '=', 'g.nidn')
                     ->on('a.kd_kelas', '=', 'g.kd_kelas')
                     ->on('a.kd_jurusan', '=', 'g.kd_jurusan')
                     ->on('a.kd_tahun', '=', 'g.kd_tahun_ajar')
                     ->on('a.kd_semester', '=', 'g.kd_semester');
            })
            ->join('m_dosen as f', 'g.nidn', '=', 'f.nidn')
            ->join('m_kelas_detail as h', function($join) {
                $join->on('g.kd_kelas', '=', 'h.kode_kelas')
                     ->on('g.kd_jurusan', '=', 'h.kd_jurusan');
            })
            ->where('a.id_kuesioner', '2')
            ->where('a.aktif', 'Y')
            ->where('h.nim', $nim)
            ->whereRaw('DATE_FORMAT(NOW(),"%Y-%m-%d %H:%i:%s") BETWEEN a.tgl_mulai AND a.tgl_selesai')
            ->select(
                'a.id_t_kuesioner', 'a.id_kuesioner', 'a.nidn', 'a.kd_tahun', 
                'a.kd_semester', 'a.kd_jurusan', 'a.tgl_mulai', 'a.tgl_selesai', 
                'a.aktif', 'f.nama', 'h.nim', 'b.id_kategori', 'b.id', 
                'd.tahun_ajar', 'e.semester', 'g.kd_kelas', 'g.kd_matakuliah'
            );

        $query2 = DB::table('t_kuesioner_evaluasi as a')
            ->join('m_kuesioner_evaluasi as b', 'a.id_kuesioner', '=', 'b.id_kategori')
            ->join('m_tahun_ajar as d', 'a.kd_tahun', '=', 'd.kd_tahun_ajar')
            ->join('m_semester as e', 'a.kd_semester', '=', 'e.kd_semester')
            ->join('m_kelas_detail as h', function($join) {
                $join->on('a.kd_kelas', '=', 'h.kode_kelas')
                     ->on('a.kd_jurusan', '=', 'h.kd_jurusan');
            })
            ->where('a.id_kuesioner', '1')
            ->where('a.aktif', 'Y')
            ->where('h.nim', $nim)
            ->whereRaw('DATE_FORMAT(NOW(),"%Y-%m-%d %H:%i:%s") BETWEEN a.tgl_mulai AND a.tgl_selesai')
            ->select(
                'a.id_t_kuesioner', 'a.id_kuesioner', 'a.nidn', 'a.kd_tahun', 
                'a.kd_semester', 'a.kd_jurusan', 'a.tgl_mulai', 'a.tgl_selesai', 
                'a.aktif', DB::raw("'' as nama"), 'h.nim', 
                'b.id_kategori', 'b.id', 'd.tahun_ajar', 'e.semester', 
                'a.kd_kelas', 'a.kd_matakuliah'
            );

        $results = $query1->union($query2)->groupBy('a.id_t_kuesioner')->get();

        return response()->json($results);
    }
    
    public function ListMatakuliah($kd_matakuliah)
    {
        $results = DB::table('kelas_perkuliahan as a')
            ->join('m_matakuliah as c', 'a.kd_matakuliah', '=', 'c.kd_matakuliah')
            ->select(
                'a.kd_jurusan',
                'a.kd_tahun_ajar',
                'a.kd_semester',
                'a.kd_kelas',
                'a.nidn',
                'a.kd_matakuliah',
                'a.jml_pertemuan',
                'c.SKS',
                'c.matakuliah',
                'a.jml_pertemuan'
            )
            ->where('a.kd_matakuliah', $kd_matakuliah)
            ->get();

        return response()->json($results);
    }
    
    public function ListPenilaian($nim, $id_kuesioner)
    {
        $penilaian = DB::table('t_jawaban_kuesioner_evaluasi as a')
            ->join('t_kuesioner_evaluasi as b', function ($join) {
                $join->on('a.nidn', '=', 'b.nidn')
                     ->on('a.kd_tahun', '=', 'b.kd_tahun')
                     ->on('a.kd_semester', '=', 'b.kd_semester')
                     ->on('a.kd_kelas', '=', 'b.kd_kelas')
                     ->on('a.kd_jurusan', '=', 'b.kd_jurusan');
            })
            ->join('m_kelas_detail as c', function ($join) {
                $join->on('a.kd_kelas', '=', 'c.kode_kelas')
                     ->on('a.kd_jurusan', '=', 'c.kd_jurusan')
                     ->on('a.nim', '=', 'c.nim');
            })
            ->where('a.nim', $nim)
            ->where('a.id_t_kuesioner', $id_kuesioner)
            ->select('a.*', 'b.*', 'c.*')
            ->get();

        return response()->json($penilaian);
    }
    
    public function ListKuesioner($id_kategori)
    {
        // Mengambil data dari database
        $kuesioner = DB::table('m_kuesioner_evaluasi as a')
            ->where('a.id_kategori', $id_kategori)
            ->where('a.aktif', 'Y')
            ->orderBy('a.id', 'ASC')
            ->select('a.id', 'a.id_kategori', 'a.judul', 'a.pertanyaan', 'a.tgl_input', 'a.aktif')
            ->get();

        // Mengembalikan respons dalam format JSON
        return response()->json($kuesioner);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), EvaluasiAkademik::dataInputRules());
    
        if ($validator->fails()) {
            return response()->json([
                'message' => 'Validasi gagal.',
                'errors' => $validator->errors(),
            ], 422);
        }
    
        try {
            $jawaban = EvaluasiAkademik::dataCreate($validator->validated());
    
            return response()->json([
                'message' => 'Jawaban berhasil disimpan.',
                'data' => $jawaban,
            ], 201);
        } catch (\Exception $e) {
            return response()->json([
                'message' => 'Terjadi kesalahan saat menyimpan jawaban.',
                'error' => $e->getMessage(),
            ], 500);
        }
    }

    

}
