<?php

namespace App\Http\Controllers;

use App\Models\JadwalKuliah;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Validator;
use Illuminate\Support\Facades\DB;

class JadwalKuliahController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth', ['only' => ['store', 'update', 'destroy', 'index', 'show']]);
    }

    public function index()
    {
        // Mengambil semua data KRS beserta relasinya
        $jadwalkuliah = JadwalKuliah::with(['jurusan', 'tahun_ajar', 'semester', 'kelas', 'kelaskuliah', 'matakuliah'])->get();

        return response()->json($jadwalkuliah);
    }

    // Mendapatkan data KRS berdasarkan NIM
    public function show($id)
    {
        // Mencari data KRS berdasarkan NIM
        $jadwalkuliah = JadwalKuliah::with(['jurusan', 'tahun_ajar', 'semester', 'kelas', 'kelaskuliah', 'matakuliah'])
            ->whereHas('kelaskuliah', function($query) use ($id) {
                $query->where('nim', $id);
            })
            ->orderBy('kd_hari', 'asc') // Mengurutkan data berdasarkan kd_hari secara ascending
            ->get();
    
        // Cek apakah data ditemukan
        if ($jadwalkuliah->isEmpty()) {
            return response()->json(['message' => 'Data tidak ditemukan'], 404);
        }
    
        return response()->json($jadwalkuliah);
    }



    // Menyimpan data KRS baru
    public function store(Request $request)
    {
        // Validasi input
        $this->validate($request, [
            'kd_jurusan' => 'required',
            'kd_tahun_ajar' => 'required',
            'kd_semester' => 'required',
            'kd_kelas' => 'required',
            'kd_matakuliah' => 'required',
            'kd_hari' => 'required',
            'jam' => 'required',
            'jam_selesai' => 'required',
        ]);

        // Menyimpan data baru
        $jadwalkuliah = JadwalKuliah::create($request->all());

        return response()->json($jadwalkuliah, 201);
    }

    // Memperbarui data KRS
    public function update(Request $request, $id)
    {
        // Mencari data KRS berdasarkan ID
        $jadwalkuliah = JadwalKuliah::find($id);

        if (!$jadwalkuliah) {
            return response()->json(['message' => 'Data tidak ditemukan'], 404);
        }

        // Validasi input
        $this->validate($request, [
            'kd_jurusan' => 'required',
            'kd_tahun_ajar' => 'required',
            'kd_semester' => 'required',
            'kd_kelas' => 'required',
            'kd_matakuliah' => 'required',
            'kd_hari' => 'required',
            'jam' => 'required',
            'jam_selesai' => 'required',
        ]);

        // Memperbarui data
        $jadwalkuliah->update($request->all());

        return response()->json($jadwalkuliah);
    }

    // Menghapus data KRS
    public function destroy($id)
    {
        // Mencari data KRS berdasarkan ID
        $jadwalkuliah = JadwalKuliah::find($id);

        if (!$jadwalkuliah) {
            return response()->json(['message' => 'Data tidak ditemukan'], 404);
        }

        // Menghapus data
        $jadwalkuliah->delete();

        return response()->json(['message' => 'Data berhasil dihapus']);
    }
}
