<?php

namespace App\Http\Controllers;

use App\Models\Kaprodi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Validator;
use Illuminate\Support\Facades\DB;

class KaprodiController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth', ['only' => ['store', 'update', 'destroy', 'index', 'show']]);
    }

    public function index(Request $request)
    {
        $kaprodi = DB::select(
            DB::raw("
                SELECT 
                    x.id AS id_sys_setting, x.keydata, x.deskripsi, x.fupload,
                    y.id_user, y.nama, z.group_name
                FROM 
                    sys_setting x
                    INNER JOIN m_user y ON x.deskripsi = y.id_user
                    INNER JOIN m_group z ON y.group_id = z.group_id
                WHERE x.keydata IN ('KaProdiD3Keperawatan','KaProdiS1AdministrasiKesehatan','KetuaSTIKes','WakilKetuaSTIKes');
            ")
        );
        return response()->json($kaprodi);
    }
    
}
