<?php

namespace App\Http\Controllers;

use App\Models\MataKuliah;
use Illuminate\Http\Request;

class MataKuliahController extends Controller
{
    // Middleware to protect specific routes
    public function __construct()
    {
        // Apply 'auth' middleware only to specified methods
        $this->middleware('auth', ['only' => ['store', 'update', 'destroy', 'index', 'show']]);
    }

    // Retrieve all records from the m_matakuliah table
    public function index()
    {
        // Ensure you use the get() method to fetch the data
        $matakuliah = MataKuliah::with(['detailmatakuliah'])->get();

        // Check if data exists
        if ($matakuliah->isEmpty()) {
            return response()->json(['message' => 'No data found'], 404);
        }

        return response()->json($matakuliah);
    }

    // Retrieve a specific record based on kd_matakuliah
    public function show($kd_matakuliah)
    {
        // Ensure find() is used to get a single record, not with get()
        $matakuliah = MataKuliah::with(['detailmatakuliah'])->where('kd_matakuliah', $kd_matakuliah)->first();

        if (!$matakuliah) {
            return response()->json(['message' => 'Data not found'], 404);
        }

        return response()->json($matakuliah);
    }

    // Create a new matakuliah
    public function store(Request $request)
    {
        // Validation logic to ensure data integrity
        $this->validate($request, [
            'kd_matakuliah' => 'required',
            'kd_jurusan' => 'required',
            'kd_jenis_matakuliah' => 'required',
            'kd_kategori' => 'required',
            'matakuliah' => 'required',
            'SKS' => 'required|integer',
            // Add other validation rules if necessary
        ]);

        // Create a new MataKuliah record using the validated request data
        $matakuliah = MataKuliah::create($request->all());

        return response()->json([
            'message' => 'Matakuliah created successfully',
            'data' => $matakuliah
        ], 201); // 201 status code for created resource
    }

    // Update a matakuliah
    public function update(Request $request, $kd_matakuliah)
    {
        // Find the matakuliah by kd_matakuliah
        $matakuliah = MataKuliah::where('kd_matakuliah', $kd_matakuliah)->first();

        if (!$matakuliah) {
            return response()->json(['message' => 'Data not found'], 404);
        }

        // Update the matakuliah record
        $matakuliah->update($request->all());

        return response()->json([
            'message' => 'Matakuliah updated successfully',
            'data' => $matakuliah
        ]);
    }

    // Delete a matakuliah
    public function destroy($kd_matakuliah)
    {
        // Find the matakuliah by kd_matakuliah
        $matakuliah = MataKuliah::where('kd_matakuliah', $kd_matakuliah)->first();

        if (!$matakuliah) {
            return response()->json(['message' => 'Data not found'], 404);
        }

        // Delete the matakuliah record
        $matakuliah->delete();

        return response()->json(['message' => 'Matakuliah deleted successfully']);
    }
}
