<?php

namespace App\Http\Controllers;

use App\Models\Pengumuman;
use App\Models\SysSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Validator;
use Illuminate\Support\Facades\DB;

class PengumumanController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth', ['only' => ['store', 'update', 'destroy', 'index', 'show']]);
    }

    public function index(Request $request)
    {
        $keydata = 'tahun_ajar_current';
    
        $syssetting = SysSetting::where('keydata', $keydata)->value('deskripsi');
    
        if (!$syssetting) {
            return response()->json(['message' => 'System setting not found'], 404);
        }
    
        $pengumuman = Pengumuman::where('kd_tahun_ajar', $syssetting)
                                ->where('kd_info_pmb', 'N')
                                ->get();
    
        return response()->json($pengumuman);
    }

    
    public function show($id)
    {
        // Menggunakan eager loading untuk memuat relasi yang diperlukan
        $pengumuman = Pengumuman::find($id);
    
        if (!$pengumuman) {
            return response()->json(['message' => 'Data not found'], 404);
        }
        
        return response()->json($pengumuman);
    }
    

}
