<?php

namespace App\Http\Controllers;

use App\Models\Prodi;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Validator;
use Illuminate\Support\Facades\DB;

class ProdiController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth', ['only' => ['store', 'update', 'destroy', 'index', 'show']]);
    }

    public function index(Request $request)
    {
        $prodi = Prodi::all();

        return response()->json($prodi);
    }
    
    public function show($id)
    {
        // Menggunakan eager loading untuk memuat relasi yang diperlukan
        $prodi = Prodi::where('kd_jurusan', $id)->first();
    
        if (!$prodi) {
            return response()->json(['message' => 'Data not found'], 404);
        }
        
        return response()->json($prodi);
    }
}
