<?php

namespace App\Http\Controllers;

use App\Models\Profile;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Validator;
use Illuminate\Support\Facades\DB;

class ProfileController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth', ['only' => ['store', 'update', 'destroy', 'index', 'show']]);
    }

    public function index(Request $request)
    {
        $profile = Profile::all();

        return response()->json($profile);
    }
    
    public function show($id)
    {
        // Menggunakan eager loading untuk memuat relasi yang diperlukan
        $profile = Profile::with(['user','group_id', 'kelurahan', 'kecamatan', 'kabupaten', 'provinsi', 'kd_agama', 'prodi', 'kelaskuliah'])
            ->where('id_user', $id)
            ->first();
    
        if (!$profile) {
            return response()->json(['message' => 'Data not found'], 404);
        }
    
        // Menambahkan tempat_lahir dan tanggal_lahir kembali ke respon secara eksplisit
        $profile->makeVisible(['tempat_lahir', 'tanggal_lahir']);
    
        return response()->json($profile);
    }

    
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), Profile::dataInputRules());
    
        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()->all()], 422);
        }
    
        $dataInput = $request->only(Profile::dataInput());
    
        $profile = Profile::create($dataInput);
    
        return response()->json(['profile' => $profile], 201);
    }
    
    public function update(Request $request, $id)
    {
        // Menggunakan WHERE pada kolom id_modul
        $profile = Profile::where('id_user', $id)->first();
    
        if (!$profile) {
            return response()->json(['message' => 'Data not found'], 404);
        }
    
        $validator = Validator::make($request->all(), Profile::dataUpdateRules($id));

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()->all()], 422);
        }
    
        $profile->update($request->only(Profile::dataInput()));
    
        // Log pesan debug
        error_log("Update success: " . json_encode($profile));
    
        return response()->json(['profile' => $profile]);
    }

    
    public function destroy($id)
    {
        $profile = Profile::where('id_user', $id)->first();
    
        if (!$profile) {
            return response()->json(['message' => 'Data not found'], 404);
        }
    
        $del_profile = $profile->replicate();
    
        if ($profile->delete()) {
            $output = [
                'item_deleted' => $del_profile,
                'message' => 'Profile deleted successfully'
            ];
    
            return response()->json($output, 200);
        } else {
            return response()->json(['message' => 'Failed to delete Profile'], 500);
        }
    }
    
    public function CariProfileAkses($levelAkses)
    {
        $aktif = 'Y';
        
        $profile = DB::table('users as a')
            ->select('a.id_user', 'a.id_group', 'a.username', 'b.nama', 'c.group_name')
            ->join('m_user as b', 'a.id_user', '=', 'b.id_user')
            ->join('m_group as c', 'a.id_group', '=', 'c.group_id')
            ->where('a.id_group', $levelAkses)
            ->where('a.aktif', $aktif)
            ->get();
        
        if (!$profile){
            return response()->json(['message' => 'Data not found'], 404);
        }
        
        return response()->json(['profile' => $profile]);
    }
}
