<?php

namespace App\Http\Controllers;

use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Validator;
use Illuminate\Support\Facades\DB;

class UserController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth', ['only' => ['store', 'update', 'destroy', 'index', 'show']]);
    }

    public function index(Request $request)
    {
        $user = User::all();

        return response()->json($user);
    }
    
    public function show($id)
    {
        $user = User::where('id_user', $id)->get();
        
        if (!$user){
            return response()->json(['message' => 'Data not found'], 404);
        }
        
        return response()->json(['user' => $user]);
    }
    
    public function saveFcmToken(Request $request) {
        $nim = $request->input('nim');
        $fcm_token = $request->input('fcm_token');

        // Validasi data
        if (empty($nim) || empty($fcm_token)) {
            return response()->json(['status' => 'error', 'message' => 'Data tidak valid']);
        }

        // Simpan atau update token FCM
        $existingToken = DB::table('user_fcm_tokens')->where('nim', $nim)->first();
        if ($existingToken) {
            // Update token jika sudah ada
            DB::table('user_fcm_tokens')
                ->where('nim', $nim)
                ->update(['fcm_token' => $fcm_token, 'created_at' => now()]);
        } else {
            // Simpan token baru
            DB::table('user_fcm_tokens')->insert([
                'nim' => $nim,
                'fcm_token' => $fcm_token,
                'created_at' => now()
            ]);
        }

        return response()->json(['status' => 'success', 'message' => 'FCM token berhasil disimpan']);
    }
}
