<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class BiayaKuliah extends Model
{
    protected $table = 't_tagihan';

    // Definisikan kolom yang dapat diisi secara massal (mass assignable)
    protected $fillable = [
        'no_tagihan', 'no_registrasi', 'kd_gelombang', 'kd_tahun_ajar', 'kd_semester', 'kd_jurusan', 'kd_biaya', 'no_kwitansi', 'tanggal_tagihan', 'tagihan'
    ];

    // Relasi ke tabel jurusan
    public function jurusan()
    {
        return $this->belongsTo(Jurusan::class, 'kd_jurusan', 'kd_jurusan');
    }

    // Relasi ke tabel tahun ajar
    public function tahun_ajar()
    {
        return $this->belongsTo(TahunAjar::class, 'kd_tahun_ajar', 'kd_tahun_ajar');
    }

    // Relasi ke tabel semester
    public function semester()
    {
        return $this->belongsTo(Semester::class, 'kd_semester', 'kd_semester');
    }

    // Relasi ke tabel mahasiswa
    public function mahasiswa()
    {
        return $this->belongsTo(Mahasiswa::class, 'no_registrasi', 'nim'); // Mengubah dari hasMany menjadi belongsTo karena satu mahasiswa punya satu tagihan
    }

    public function komponenbiayakuliah($kd_jurusan = null, $kd_semester = null, $kd_biaya = null, $kd_tahun_ajar = null)
    {
        // Log nilai sebelum digunakan
        \Log::info('kd_jurusan: ' . $kd_jurusan);
        \Log::info('kd_semester: ' . $kd_semester);
        \Log::info('kd_biaya: ' . $kd_biaya);
        \Log::info('kd_tahun_ajar: ' . $kd_tahun_ajar);
    
        $query = $this->hasMany(KomponenBiayaKuliah::class, 'kd_jurusan', 'kd_jurusan');
    
        if ($kd_semester) {
            $query->where('kd_semester', $kd_semester);
        }
    
        if ($kd_biaya) {
            $query->where('kd_biaya', $kd_biaya);
        }
    
        if ($kd_tahun_ajar) {
            $query->where('tgl_berlaku', $kd_tahun_ajar);
        }
    
        return $query;
    }






}
