<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class KomponenBiayaKuliah extends Model
{
    protected $table = 'm_biaya_tarif';

    // Definisikan kolom yang dapat diisi secara massal (mass assignable)
    protected $fillable = [
        'kd_jurusan', 'kd_biaya', 'kd_semester', 'tgl_berlaku', 'tarif'
    ];

    // Relasi ke tabel m_biaya
    public function biaya()
    {
        return $this->belongsTo(Biaya::class, 'kd_biaya', 'kd_biaya');
    }
}
