<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Krs extends Model
{
    protected $table = 'kelas_perkuliahan';

    // Definisikan kolom yang dapat diisi secara massal (mass assignable)
    protected $fillable = [
        'kd_jurusan', 'kd_tahun_ajar', 'kd_semester', 'kd_kelas', 'nidn', 'kd_matakuliah', 'jml_pertemuan'
    ];

    // Jika Anda memiliki relasi, definisikan di sini
    public function jurusan()
    {
        return $this->belongsTo(Jurusan::class, 'kd_jurusan', 'kd_jurusan');
    }

    public function tahun_ajar()
    {
        return $this->belongsTo(TahunAjar::class, 'kd_tahun_ajar', 'kd_tahun_ajar');
    }

    public function semester()
    {
        return $this->belongsTo(Semester::class, 'kd_semester', 'kd_semester');
    }

    public function dosen()
    {
        return $this->belongsTo(Dosen::class, 'nidn', 'nidn');
    }

    public function kelas()
    {
        return $this->belongsTo(Kelas::class, 'kd_kelas', 'kode_kelas');
    }

    public function mahasiswa()
    {
        return $this->hasMany(Mahasiswa::class, 'kd_kelas', 'kode_kelas');
    }
}
