<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Mahasiswa extends Model 
{

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'm_mahasiswa';
    
    // Primary key dari tabel
    protected $primaryKey = 'nim'; // Sesuaikan dengan primary key pada tabel m_user

    /**
     * The attributes that are mass assignable.
     *
     * @var string[]
     */
    protected $fillable = [
        'nim', 
        'nama_lengkap', 
        'tempat_lahir', 
        'tanggal_lahir', 
        'kd_internal', 
        'kd_tahun_masuk', 
        'kd_semester', 
        'kd_jurusan', 
        'no_identitas', 
        'jenis_kelamin', 
        'kd_agama', 
        'berat_badan', 
        'tinggi_badan', 
        'alamat', 
        'rt', 
        'rw', 
        'kd_kelurahan', 
        'kd_kecamatan', 
        'kd_kabkot', 
        'kd_prov', 
        'telepon1', 
        'telepon2', 
        'email', 
        'nama_ibu', 
        'asal_sekolah', 
        'fupload', 
        'kd_status'
    ];

    
    // Kolom yang disembunyikan dalam array atau JSON output
    protected $hidden = [];

    // Menonaktifkan timestamps jika tabel tidak memiliki kolom created_at dan updated_at
    public $timestamps = false;
    
    public static function dataInput()
    {
        return [
            'nim', 
            'nama_lengkap', 
            'tempat_lahir', 
            'tanggal_lahir', 
            'kd_internal', 
            'kd_tahun_masuk', 
            'kd_semester', 
            'kd_jurusan', 
            'no_identitas', 
            'jenis_kelamin', 
            'kd_agama', 
            'berat_badan', 
            'tinggi_badan', 
            'alamat', 
            'telepon1', 
            'telepon2', 
            'email', 
            'nama_ibu', 
            'asal_sekolah'
        ];
    }



    public static function dataUpdateRules($id)
    {
        return [
            'nim' => 'required',
            'nama_lengkap' => 'required',
        ];
    }
    
    public static function dataInputRules()
    {
        return [
            'nim' => 'required',
            'nama_lengkap' => 'required',
        ];
    }
    
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }
    
    public function tahun_ajar()
    {
        return $this->belongsTo(TahunAjar::class,'kd_tahun_masuk', 'kd_tahun_ajar');
    }
    
    public function semester()
    {
        return $this->belongsTo(Semester::class,'kd_semester', 'kd_semester');
    }
    
    public function jurusan()
    {
        return $this->belongsTo(Jurusan::class,'kd_jurusan', 'kd_jurusan');
    }
    
    public function agama()
    {
        return $this->belongsTo(Agama::class, 'kd_agama', 'kd_agama');
    }
    
    public function kelurahan()
    {
        return $this->belongsTo(Kelurahan::class,'kd_kelurahan', 'id_kel');
    }
    
    public function kecamatan()
    {
        return $this->belongsTo(Kecamatan::class, 'kd_kecamatan', 'id_kec');
    }
    
    public function kabupaten()
    {
        return $this->belongsTo(Kabupaten::class, 'kd_kabkot', 'id_kab');
    }
    
    public function provinsi()
    {
        return $this->belongsTo(Provinsi::class, 'kd_prov', 'id_prov');
    }
}
