<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MataKuliah extends Model
{
    // Define the table
    protected $table = 'm_matakuliah';

    // Disable timestamps if not needed
    public $timestamps = false;

    // Define the primary key if it's not 'id'
    protected $primaryKey = 'kd_matakuliah';

    // The attributes that are mass assignable
    protected $fillable = [
        'kd_matakuliah', 'kd_jurusan', 'kd_jenis_matakuliah', 'kd_kategori', 'matakuliah', 'SKS',
        'metode_kuliah', 'sap', 'silabus', 'bahan_ajar', 'acara_praktek', 'diktat', 'nidn',
        'tgl_mulai_efektif', 'tgl_akhir_efektif'
    ];

    // Specify the primary key type
    protected $keyType = 'string';
    
    // Jika Anda memiliki relasi, definisikan di sini
    public function detailmatakuliah()
    {
        return $this->belongsTo(DetailMataKuliah::class, 'kd_matakuliah', 'kd_matakuliah');
    }
}
