<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class MateriPerkuliahan extends Model
{
    protected $table = 't_materi_kuliah_dosen';
    protected $fillable = [
        'kd_tahun_ajar', 'kd_semester', 'kd_jurusan', 'keterangan',
        'gambar', 'file', 'keydata', 'dibaca', 'nidn', 'tgl_input', 'kd_matakuliah'
    ];

    public function tahunAjar()
    {
        return $this->belongsTo(TahunAjar::class, 'kd_tahun_ajar', 'kd_tahun_ajar');
    }

    public function semester()
    {
        return $this->belongsTo(Semester::class, 'kd_semester', 'kd_semester');
    }

    public function jurusan()
    {
        return $this->belongsTo(Jurusan::class, 'kd_jurusan', 'kd_jurusan');
    }

    public function fakultas()
    {
        return $this->hasOneThrough(Fakultas::class, Jurusan::class, 'kd_jurusan', 'kd_fakultas', 'kd_jurusan', 'kd_fakultas');
    }

    public function dosen()
    {
        return $this->belongsTo(Dosen::class, 'nidn', 'nidn');
    }

    public function matakuliah()
    {
        return $this->belongsTo(Matakuliah::class, 'kd_matakuliah', 'kd_matakuliah');
    }

    public function kelasPerkuliahan()
    {
        return $this->hasMany(KelasPerkuliahan::class, 'kd_matakuliah', 'kd_matakuliah')
            ->where('kd_jurusan', $this->kd_jurusan)
            ->where('kd_tahun_ajar', $this->kd_tahun_ajar)
            ->where('kd_semester', $this->kd_semester)
            ->where('nidn', $this->nidn);
    }

    public function kelasKuliah()
    {
        return $this->hasMany(KelasKuliah::class, 'kd_jurusan', 'kd_jurusan')
            ->where('kd_tahun_ajar', $this->kd_tahun_ajar)
            ->where('kd_semester', $this->kd_semester);
    }
}
