<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Profile extends Model
{
    // Nama tabel dalam database
    protected $table = 'm_user';

    // Primary key dari tabel
    protected $primaryKey = 'id'; // Sesuaikan dengan primary key pada tabel m_user
    
    /**
     * The attributes that are mass assignable.
     *
     * @var string[]
     */
    protected $fillable = [
        'id_user',
        'id_ktp', 
        'nama', 
        'jenis_kelamin', 
        'tempat_lahir', 
        'tanggal_lahir', 
        'kd_agama', 
        'berat_badan', 
        'tinggi_badan', 
        'nama_ibu', 
        'npwp', 
        'alamat', 
        'rt', 
        'rw', 
        'kelurahan', 
        'kecamatan', 
        'kabupaten', 
        'provinsi', 
        'zipcode', 
        'pas_photo',
        'fupload',
        'aktif',
        'tgl_registrasi', 
        'email',
        'no_tlp', 
        'telepon2'
    ];

    
    // Kolom yang disembunyikan dalam array atau JSON output
    protected $hidden = [
        'id_ktp', 
        'nama_ibu', 
        'tempat_lahir', 
        'tanggal_lahir', 
    ];

    // Menonaktifkan timestamps jika tabel tidak memiliki kolom created_at dan updated_at
    public $timestamps = false;
    
    public static function dataInput()
    {
        return [
            'id_user',
            'id_ktp', 
            'nama', 
            'jenis_kelamin', 
            'tempat_lahir', 
            'tanggal_lahir', 
            'kd_agama', 
            'berat_badan', 
            'tinggi_badan', 
            'nama_ibu', 
            'npwp', 
            'alamat', 
            'rt', 
            'rw', 
            'kelurahan', 
            'kecamatan', 
            'kabupaten', 
            'provinsi', 
            'zipcode', 
            'pas_photo', 
            'fupload',
            'aktif',
            'tgl_registrasi', 
            'email',
            'no_tlp', 
            'telepon2'
        ];
    }



    public static function dataUpdateRules($id)
    {
        return [
            'id_user' => 'required',
            'nama' => 'required',
        ];
    }
    
    public static function dataInputRules()
    {
        return [
            'id_user' => 'required',
            'nama' => 'required',
        ];
    }
    
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    /**
     * Return a key value array, containing any custom claims to be added to the JWT.
     *
     * @return array
     */
    public function getJWTCustomClaims()
    {
        return [];
    }
    
    public function user()
    {
        return $this->belongsTo(User::class, 'id_user', 'id_user');
    }
    
    public function group_id()
    {
        return $this->belongsTo(GroupAkses::class, 'group_id', 'group_id');
    }
    
    public function kelurahan()
    {
        return $this->belongsTo(Kelurahan::class, 'kelurahan', 'id_kel');
    }
    
    public function kecamatan()
    {
        return $this->belongsTo(Kecamatan::class, 'kecamatan', 'id_kec');
    }
    
    public function kabupaten()
    {
        return $this->belongsTo(Kabupaten::class, 'kabupaten', 'id_kab');
    }
    
    public function provinsi()
    {
        return $this->belongsTo(Provinsi::class, 'provinsi', 'id_prov');
    }
    
    public function kd_agama()
    {
        return $this->belongsTo(Agama::class, 'kd_agama', 'kd_agama');
    }
    
    public function prodi()
    {
        return $this->belongsTo(Prodi::class, 'id_company', 'kd_jurusan');
    }
    
    public function kelaskuliah()
    {
        return $this->belongsTo(KelasKuliah::class, 'id_user', 'nim');
    }
}
