<?php

namespace App\Models;

use Illuminate\Auth\Authenticatable;
use Illuminate\Contracts\Auth\Access\Authorizable as AuthorizableContract;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Laravel\Lumen\Auth\Authorizable;
use Tymon\JWTAuth\Contracts\JWTSubject;
use Illuminate\Notifications\Notifiable;

class User extends Model implements AuthenticatableContract, AuthorizableContract, JWTSubject 
{
    use Authenticatable, Authorizable, HasFactory, Notifiable;

    public static function boot()
    {
        parent::boot();
        static::creating(function($model)
        {
            $user = auth()->user();
            $model->created_by = is_object($user) ? $user->id : 1;
            $model->updated_by = is_object($user) ? $user->id : 1;
        });
        static::updating(function($model)
        {
            $user = auth()->user();
            $model->updated_by = is_object($user) ? $user->id : 1;
        });       
    }
    
    const IS_ACTIVE_TRUE = 'Y';
    const IS_ACTIVE_FALSE = 'N';

    /**
     * The attributes that are mass assignable.
     *
     * @var string[]
     */
    protected $fillable = [
        'id_user', 
        'id_company', 
        'id_group', 
        'username',
        'pass_mobile',
    ];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var string[]
     */
    protected $hidden = [
        'pass_mobile',
    ];

    public static function dataCreate($data){
        self::unguard();
        $model = self::create($data);
        self::reguard();
        
        return $model;        
    }

    public static function dataInput()
    {
        return [
            'id_user', 
            'id_company', 
            'id_group', 
            'username',
            'pass_mobile',         
        ];
    }

    public static function dataInputRules()
    {
        return [
            'id_user' => 'required',
            'id_company' => 'required',
            'id_group' => 'required',
            'username' => 'required',
            'pass_mobile' => 'required',
        ];
    }

    public static function dataUpdateRules($id)
    {
        return [
            'id_user' => 'required',
            'id_company' => 'required',
            'id_group' => 'required',
            'username' => 'required',
        ];
    }

    // Implement JWT methods
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [];
    }

    // Relasi dengan Role
    public function roles(){
        return $this->belongsToMany('App\Models\Role')->withTimestamps();
    }
    
    // Relasi dengan GroupAkses
    public function group()
    {
        return $this->belongsTo(GroupAkses::class, 'id_group', 'id');
    }
    
    // Relasi dengan Profile
    public function profile()
    {
        return $this->hasOne(Profile::class, 'id_user', 'id_user');
    }
    
    public function CalonMahasiswa()
    {
        // Log::info("Mencari calon mahasiswa dengan no_registrasi: {$this->id_user} dan kd_gelombang: {$this->kd_gelombang}");
    
        return $this->hasOne(CalonMahasiswa::class, 'no_registrasi', 'id_user')
                    ->where('kd_gelombang', $this->kd_gelombang);
    }


}
