<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class PesananNotification extends Notification
{
    use Queueable;

    /**
     * Create a new notification instance.
     *
     * @return void
     */
    private $orders;
    private $status_id;
    public function __construct($orders, $status_id)
    {
        $this->orders = $orders;
        $this->status_id = $status_id;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['database'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->line('The introduction to the notification.')
                    ->action('Notification Action', url('/'))
                    ->line('Thank you for using our application!');
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        if ($this->status_id==1) {
            return [
                'order_id' => $this->orders->id,
                'order_number' => $this->orders->order_number,
                'ordernumber' => str_replace('/', '', $this->orders->order_number),
                'customer_name' => $this->orders->customer_name,
                'unit_name' => $this->orders->place_of_order_name,
                'title' => 'Pesanan Baru',
                'messages' => 'Dibuat oleh '.$this->orders->customer_name.', Bagian '.$this->orders->place_of_order_name,
            ];
        } else if ($this->status_id==6) {
            return [
                'order_id' => $this->orders->id,
                'order_number' => $this->orders->order_number,
                'ordernumber' => str_replace('/', '', $this->orders->order_number),
                'customer_name' => $this->orders->customer_name,
                'unit_name' => $this->orders->place_of_order_name,
                'title' => 'Proses Pesanan Baru',
                'messages' => 'Ada pesanan yang harus diproses, nomor : '.$this->orders->order_number,
            ];
        } else if ($this->status_id==7) {
            return [
                'order_id' => $this->orders->id,
                'order_number' => $this->orders->order_number,
                'ordernumber' => str_replace('/', '', $this->orders->order_number),
                'customer_name' => $this->orders->customer_name,
                'unit_name' => $this->orders->place_of_order_name,
                'title' => 'Atur Pengiriman',
                'messages' => 'No Pesanan '.$this->orders->order_number.' harus diatur pengiriman!',
            ];
        }
    }
}
