<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateInitTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cost_centers', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('description')->nullable();
            $table->timestamps();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable(); 
        });

        /** Menu untuk pihak user */
        Schema::create('menu_of_orders', function (Blueprint $table) {
            $table->id();            
            $table->string('name');                        
            $table->string('description')->nullable();
            $table->timestamps();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable(); 
        });

        /** Menu untuk pihak Rumah Tangga */
        Schema::create('menu_serve_of_orders', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('budget_id');
            $table->bigInteger('vendor_id');
            $table->string('name');            
            $table->decimal('price', 20, 2)->default(0);
            $table->integer('margin_status')->default(0); // 0: Tidak memiliki margin, 1: Memiliki margin
            $table->integer('event_status')->default(0);  // 0: Tidak memiliki event , 1: Memiliki event
            $table->string('description')->nullable();
            $table->timestamps();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable(); 
        });

        Schema::create('units', function (Blueprint $table) {
            $table->id();
            $table->string('name');            
            $table->timestamps();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable(); 
        });

        Schema::create('events', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('description')->nullable();
            $table->timestamps();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable(); 
        });

        Schema::create('visitors', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('description')->nullable();
            $table->timestamps();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable(); 
        });

        Schema::create('vendors', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->integer('margin');
            $table->string('address')->nullable();
            $table->string('phone')->nullable();
            $table->string('description')->nullable();
            $table->timestamps();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable(); 
        });

        Schema::create('place_of_deliveries', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('description')->nullable();
            $table->timestamps();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable(); 
        });

        Schema::create('place_of_orders', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('description')->nullable();
            $table->timestamps();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable(); 
        });

        Schema::create('budgets', function (Blueprint $table) {
            $table->id();
            $table->bigInteger('cost_center_id');
            $table->string('name');
            $table->decimal('amount', 20, 2)->default(0);
            $table->string('description')->nullable();
            $table->timestamps();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable(); 
        });

        Schema::create('apps_settings', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('value');
            $table->string('description')->nullable();
            $table->timestamps();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable(); 
        });

        Schema::create('delivery_mans', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('badge');
            $table->integer('status')->default(0);
            $table->timestamps();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable(); 
        });

        Schema::create('guests', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('description')->nullable();
            $table->timestamps();
            $table->bigInteger('created_by')->nullable();
            $table->bigInteger('updated_by')->nullable();            
        });

    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cost_centers');
        Schema::dropIfExists('menu_of_orders');
        Schema::dropIfExists('menu_serve_of_orders');
        Schema::dropIfExists('units');
        Schema::dropIfExists('events');
        Schema::dropIfExists('visitors');
        Schema::dropIfExists('vendors');
        Schema::dropIfExists('place_of_deliveries');
        Schema::dropIfExists('place_of_orders');
        Schema::dropIfExists('budgets');
        Schema::dropIfExists('apps_settings');
        Schema::dropIfExists('delivery_mans');
        Schema::dropIfExists('guests');
    }
}
