<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class AdminPassword extends Seeder
{
    public function run()
    {
        $this->command->info('Change Admin Password');
        $uname = $this->command->ask('Admin username:', 'admin');
        
        if (!in_array($uname, ['admin', 'pn1'])) {
            $this->command->error('Admin user not found!');
            exit();
        }
        
        $user = User::where('uname', $uname)->first();
        
        if ($user) {

            $adminPassword = $this->command->ask('New Password:', Str::random(16));
            $user->password = Hash::make($adminPassword);
            $user->save();
            
            $this->command->info('Admin password updated!');
            $this->command->alert('New '.$uname.' password: ' . $adminPassword);
            
        } else {
            $this->command->error('Admin user not found!');
        }
        
    }
}
