<?php

namespace Database\Seeders;

use App\Models\Role;
use Illuminate\Support\Facades\DB;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class InitSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        
        DB::unprepared(file_get_contents('database/data/001_menus.sql'));

        $systemPassword = Str::random(16);
        $adminPassword = Str::random(16);

        $this->command->info('Initial Seeder');

        $this->createUser('system', 'System', 'system' . User::EMAIL_DEFAULT_DOMAIN, $systemPassword, 'superadmin');
                
        $this->createUser('admin', 'Administrator', 'admin' . User::EMAIL_DEFAULT_DOMAIN, $adminPassword, 'admin');   
                
        $this->command->alert('New System password: ' . $systemPassword); 
        $this->command->alert('New Administrator password: ' . $adminPassword); 

    }


    private function createUser($uname, $name, $email, $password, $roleSlug) {
        User::unguard();
        $user = User::create([
            'uname' => $uname,
            'name' => $name,
            'email' => $email,
            'password' => Hash::make($password),
            'is_active' => 1
        ]);
        User::reguard();
        $roleId = Role::getIdBySlug($roleSlug);
        $user->addRoleId($roleId);
        return $user;
    }

}