<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Role;
use App\Models\User;

class RoleSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        Role::unguard();
        $data = [
            [
                'title' => 'Super Admin',
                'slug' => 'superadmin',
                'description' => 'Akses penuh ke dalam seluruh sistem aplikasi dan setting konfigurasi aplikasi',
            ],
            [
                'title' => 'Admin',
                'slug' => 'admin',
                'description' => 'Akses penuh ke dalam sistem aplikasi',
            ],
            [
                'title' => 'Manager',
                'slug' => 'manager',
                'description' => 'Akses penuh ke dalam sistem aplikasi [approval]',
            ],
            [
                'title' => 'Pegawai',
                'slug' => 'employee',
                'description' => 'Staff yang ada di lingkungan rumah tangga',
            ],
            [
                'title' => 'Kurir',
                'slug' => 'mesengger',
                'description' => 'Kurir',
            ],            
        ];
        Role::insert($data);
        Role::reguard();
    }
}
